<?php
/*
  $Id: multibanco.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

/**
 * The administration side of the multibanco payment module
 */

  class osC_Payment_multibanco extends osC_Payment_Admin {

/**
 * The administrative title of the payment module
 *
 * @var string
 * @access private
 */

    var $_title;

/**
 * The code of the payment module
 *
 * @var string
 * @access private
 */

    var $_code = 'multibanco';

/**
 * The developers name
 *
 * @var string
 * @access private
 */

    var $_author_name = 'Ifthen Software - Ivo Afonso';

/**
 * The developers address
 *
 * @var string
 * @access private
 */

    var $_author_www = 'http://www.ifthensoftware.com';

/**
 * The status of the module
 *
 * @var boolean
 * @access private
 */

    var $_status = false;

/**
 * Constructor
 */

    function osC_Payment_multibanco() {
      global $osC_Language;

      $this->_title = "Multibanco";
      $this->_description = "Multibanco";
      $this->_method_title = "Multibanco";
      $this->_status = (defined('MODULE_PAYMENT_multibanco_STATUS') && (MODULE_PAYMENT_multibanco_STATUS == '1') ? true : false);
      $this->_sort_order = (defined('MODULE_PAYMENT_multibanco_SORT_ORDER') ? MODULE_PAYMENT_multibanco_SORT_ORDER : null);
    }

/**
 * Checks to see if the module has been installed
 *
 * @access public
 * @return boolean
 */

    function isInstalled() {
      return (bool)defined('MODULE_PAYMENT_multibanco_STATUS');
    }

/**
 * Installs the module
 *
 * @access public
 * @see osC_Payment_Admin::install()
 */

    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Activar o Mdulo Multibanco', 'MODULE_PAYMENT_multibanco_STATUS', '-1', 'Deseja aceitar pagamentos por multibanco?', '6', '0', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Zona de Pagamento', 'MODULE_PAYMENT_multibanco_ZONE', '0', 'Se escolher uma zona o pagamento s ficar disponvel para clientes dessa mesma zona.', '6', '0', 'osc_cfg_use_get_zone_class_title', 'osc_cfg_set_zone_classes_pull_down_menu', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordem', 'MODULE_PAYMENT_multibanco_SORT_ORDER', '0', 'Ordem em que o mdulo  apresentado. Mais pequeno  sempre o primeiro.', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Estado da Encomenda', 'MODULE_PAYMENT_multibanco_ORDER_STATUS_ID', '" . DEFAULT_ORDERS_STATUS_ID . "', 'Estado da encomenda aquando da escolha deste meio de pagamento', '6', '0', 'osc_cfg_set_order_statuses_pull_down_menu', 'osc_cfg_use_get_order_status_title', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Entidade', 'MODULE_PAYMENT_multibanco_ENTIDADE', '', 'A entidade fornecida pela empresa Ifthen Software no acto do contrato.', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Subentidade', 'MODULE_PAYMENT_multibanco_SUBENTIDADE', '', 'A subentidade fornecida pela empresa Ifthen Software no acto do contrato.', '6', '0', now())");
  }

/**
 * Return the configuration parameter keys in an array
 *
 * @access public
 * @return array
 */

    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('MODULE_PAYMENT_multibanco_STATUS',
                             'MODULE_PAYMENT_multibanco_ZONE',
                             'MODULE_PAYMENT_multibanco_SORT_ORDER',
                             'MODULE_PAYMENT_multibanco_ORDER_STATUS_ID',
                             'MODULE_PAYMENT_multibanco_ENTIDADE',
                             'MODULE_PAYMENT_multibanco_SUBENTIDADE');
      }

      return $this->_keys;
    }
  }
?>

