<?php
/*
  $Id: multibanco.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Payment_multibanco extends osC_Payment {
    
  var $_title,
        $_code = 'multibanco',
        $_status = false,
        $_sort_order,
        $_order_id;

    function osC_Payment_multibanco() {
      global $osC_Database, $osC_Language, $osC_ShoppingCart;

      $this->_title = "Multibanco";
      $this->_method_title  = "Multibanco";
      $this->_status = (MODULE_PAYMENT_multibanco_STATUS == '1') ? true : false;
      $this->_sort_order = MODULE_PAYMENT_multibanco_SORT_ORDER;

      if ($this->_status === true) {
        if ((int)MODULE_PAYMENT_multibanco_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_multibanco_ORDER_STATUS_ID;
        }

        if ((int)MODULE_PAYMENT_multibanco_ZONE > 0) {
          $check_flag = false;

          $Qcheck = $osC_Database->query('select zone_id from :table_zones_to_geo_zones where geo_zone_id = :geo_zone_id and zone_country_id = :zone_country_id order by zone_id');
          $Qcheck->bindTable(':table_zones_to_geo_zones', TABLE_ZONES_TO_GEO_ZONES);
          $Qcheck->bindInt(':geo_zone_id', MODULE_PAYMENT_multibanco_ZONE);
          $Qcheck->bindInt(':zone_country_id', $osC_ShoppingCart->getBillingAddress('country_id'));
          $Qcheck->execute();

          while ($Qcheck->next()) {
            if ($Qcheck->valueInt('zone_id') < 1) {
              $check_flag = true;
              break;
            } elseif ($Qcheck->valueInt('zone_id') == $osC_ShoppingCart->getBillingAddress('zone_id')) {
              $check_flag = true;
              break;
            }
          }

          if ($check_flag == false) {
            $this->_status = false;
          }
        }
      }
    }
  

   function selection() {
    return array('id' => $this->_code,
                 'module' => $this->_method_title);
   }
   
   function format_number($number) 
	{ 
		$verifySepDecimal = number_format(99,2);
	
		$valorTmp = $number;
	
		$sepDecimal = substr($verifySepDecimal, 2, 1);
	
		$hasSepDecimal = True;
	
		$i=(strlen($valorTmp)-1);
	
		for($i;$i!=0;$i-=1)
		{
			if(substr($valorTmp,$i,1)=="." || substr($valorTmp,$i,1)==","){
				$hasSepDecimal = True;
				$valorTmp = trim(substr($valorTmp,0,$i))."@".trim(substr($valorTmp,1+$i));
				break;
			}
		}
	
		if($hasSepDecimal!=True){
			$valorTmp=number_format($valorTmp,2);
		
			$i=(strlen($valorTmp)-1);
		
			for($i;$i!=1;$i--)
			{
				if(substr($valorTmp,$i,1)=="." || substr($valorTmp,$i,1)==","){
					$hasSepDecimal = True;
					$valorTmp = trim(substr($valorTmp,0,$i))."@".trim(substr($valorTmp,1+$i));
					break;
				}
			}
		}
	
		for($i=1;$i!=(strlen($valorTmp)-1);$i++)
		{
			if(substr($valorTmp,$i,1)=="." || substr($valorTmp,$i,1)=="," || substr($valorTmp,$i,1)==" "){
				$valorTmp = trim(substr($valorTmp,0,$i)).trim(substr($valorTmp,1+$i));
				break;
			}
		}
	
		if (strlen(strstr($valorTmp,'@'))>0){
			$valorTmp = trim(substr($valorTmp,0,strpos($valorTmp,'@'))).trim($sepDecimal).trim(substr($valorTmp,strpos($valorTmp,'@')+1));
		}
		
		return $valorTmp; 
	} 
	//FIM TRATAMENTO DEFINIES REGIONAIS


	//INICIO REF MULTIBANCO

function GenerateMbRef($ent_id, $subent_id, $order_id, $order_value)
{


		$order_id ="0000".$order_id;

		$order_value =  $this->format_number($order_value);

		//Apenas sao considerados os 4 caracteres mais a direita do order_id
		$order_id = substr($order_id, (strlen($order_id) - 4), strlen($order_id));


	if ($order_value < 1){
                 echo "Lamentamos mas  impossvel gerar uma referncia MB para valores inferiores a 1 Euro";
                 return;
           }
           if ($order_value >= 1000000){
                 echo "<b>AVISO:</b> Pagamento fraccionado por exceder o valor limite para pagamentos no sistema Multibanco<br>";
           }
           while ($order_value >= 1000000){
                 GenerateMbRef($order_id++, 999999.99);
                 $order_value -= 999999.99;
           }
                              
           
        //clculo dos check digits
		
		   
           $chk_str = sprintf('%05u%03u%04u%08u', $ent_id, $subent_id, $order_id, round($order_value*100));
		   
           $chk_array = array(3, 30, 9, 90, 27, 76, 81, 34, 49, 5, 50, 15, 53, 45, 62, 38, 89, 17, 73, 51);
           
           for ($i = 0; $i < 20; $i++)
           {
                 $chk_int = substr($chk_str, 19-$i, 1);
                 $chk_val += ($chk_int%10)*$chk_array[$i];
           }
           
           $chk_val %= 97;
           
           $chk_digits = sprintf('%02u', 98-$chk_val);
		
		return $subent_id." ".substr($chk_str, 8, 3)." ".substr($chk_str, 11, 1).$chk_digits;
              

    }
    
   function confirmation() {
	global $osC_ShoppingCart, $osC_Database;
	
	
	
	$totalValue = $osC_ShoppingCart->getTotal();
	
	$this->_order_id = osC_Order::insert(ORDERS_STATUS_PREPARING);
	  
	  
	$ref2 = $this->GenerateMbRef(MODULE_PAYMENT_multibanco_ENTIDADE, MODULE_PAYMENT_multibanco_SUBENTIDADE, $this->_order_id, $totalValue);
	
	$ref = '<table cellpadding="3" width="300px" bgcolor="#FFFFFF" cellspacing="0" style="margin-top: 10px;border: 1px solid #45829F">
    <tr>
        <td style="font-size: x-small; border-bottom: 1px solid #45829F; background-color: #45829F; color: White" colspan="3">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pagamento por Multibanco ou Homebanking</td>
    </tr>
    <tr>
        <td rowspan="3">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <img src="http://img412.imageshack.us/img412/9672/30239592.jpg" alt="" width="52" height="60"/></td>
        <td style="font-size: x-small; font-weight:bold; text-align:left">Entidade:</td>
        <td style="font-size: x-small; text-align:left">'.MODULE_PAYMENT_multibanco_ENTIDADE.'</td>
    </tr>
    <tr>
        <td style="font-size: x-small; font-weight:bold; text-align:left">Refer&ecirc;ncia:</td>
        <td style="font-size: x-small; text-align:left">'.$ref2.'</td>
    </tr>
    <tr>
        <td style="font-size: x-small; font-weight:bold; text-align:left">Valor:</td>
        <td style="font-size: x-small; text-align:left">'.number_format($totalValue,2).' &euro;</td>
    </tr>
    <tr>
        <td style="font-size: xx-small;border-top: 1px solid #45829F; background-color: #45829F; color: White" colspan="3">O tal&atilde;o emitido pela caixa autom&aacute;tica faz prova de pagamento. Conserve-o.</td>
    </tr>
</table>';
	  
//$osC_Database->simpleQuery("INSERT INTO ".TABLE_ORDERS_STATUS_HISTORY." (orders_id, orders_status_id, date_added, customer_notified, comments) VALUES ('100', '1', '1', now(), '0', 'dasdasdasd')");

$Qtransaction = $osC_Database->query('insert into :table_orders_transactions_history (orders_id, orders_status_id, customer_notified, comments, date_added) values (:orders_id, :orders_status_id, :customer_notified, :comments, now())');
            $Qtransaction->bindTable(':table_orders_transactions_history', TABLE_ORDERS_STATUS_HISTORY);
            $Qtransaction->bindInt(':orders_id', $this->_order_id);
            $Qtransaction->bindInt(':orders_status_id', 1);
            $Qtransaction->bindInt(':customer_notified', 0);
            $Qtransaction->bindValue(':comments', "Entidade: ".MODULE_PAYMENT_multibanco_ENTIDADE."                            \nReferencia: ".$ref2."                             \nValor: ".number_format($totalValue,2)." ");
            $Qtransaction->execute();

	
	$confirmation = array('title' => $ref);
												   
    return $confirmation;
  }

  function process() {
      $this->_order_id = osC_Order::insert();
      osC_Order::process($this->_order_id, $this->order_status);
    }
  }
?>
