<?php


 class multibanco extends base{
    var $code, $title, $description, $enabled, $pag;

// class constructor
    function multibanco() {

      global $order, $customer_id, $insert_id, $order;
      $this->code = 'multibanco';
      $this->title = Multibanco;
      $this->description = "Modulo para pagamento Multibanco.";
	  $this->entidade=MODULE_PAYMENT_MULTIBANCO_ENTIDADE;
	  $this->sub_entidade=MODULE_PAYMENT_MULTIBANCO_SUB_ENTIDADE;
      $this->email_footer =
		MODULE_PAYMENT_MULTIBANCO_TEXT_CONFIRMATION."\n\n".MODULE_PAYMENT_MULTIBANCO_TEXT_SELECTION;
		
      $this->sort_order = MODULE_PAYMENT_MULTIBANCO_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_MULTIBANCO_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_MULTIBANCO_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_MULTIBANCO_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();
    }

// class methods
  function update_status() {
    global $order, $db;

    if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_MULTIBANCO_ZONE > 0) ) {
      $check_flag = false;
      $check_query = $db->Execute("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_MULTIBANCO_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
      while (!$check_query->EOF) {
        if ($check_query->fields['zone_id'] < 1) {
          $check_flag = true;
          break;
        } elseif ($check_query->fields['zone_id'] == $order->billing['zone_id']) {
          $check_flag = true;
          break;
        }
        $check_query->MoveNext();
      }

      if ($check_flag == false) {
        $this->enabled = false;
      }
    }
  }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }
    
    

function GenerateMbRef($order_id, $order_value)
{
//     IMPORTANTE: Coloque aqui o seu codigo de entidade e sub-entidade correctamente
       $ent_id = MODULE_PAYMENT_MULTIBANCO_ENTIDADE;
       $subent_id = MODULE_PAYMENT_MULTIBANCO_SUB_ENTIDADE;
	   $order_id ="0000".$order_id;
	   
	   //     Apenas so considerados os 4 caracteres mais  direita do order_id
       $order_id = substr($order_id, (strlen($order_id) - 4), strlen($order_id));


     if ($order_value < 1){
                 echo "Lamentamos mas  impossvel gerar uma referncia MB para valores inferiores a 1 Euro";
                 return;
           }
           if ($order_value >= 1000000){
                 echo "<b>AVISO:</b> Pagamento fraccionado por exceder o valor limite para pagamentos no sistema Multibanco<br>";
           }
           while ($order_value >= 1000000){
                 GenerateMbRef($order_id++, 999999.99);
                 $order_value -= 999999.99;
           }
                              
           
        //clculo dos check digits
		   
           $chk_str = sprintf('%05u%03u%04u%08u',$ent_id, $subent_id, $order_id, round($order_value*100));
		   
           $chk_array = array(3, 30, 9, 90, 27, 76, 81, 34, 49, 5, 50, 15, 53, 45, 62,38, 89, 17, 73, 51);
           
           for ($i = 0; $i < 20; $i++)
           {
                 $chk_int = substr($chk_str, 19-$i, 1);
                 $chk_val += ($chk_int%10)*$chk_array[$i];
           }
           
           $chk_val %= 97;
           
           $chk_digits = sprintf('%02u', 98-$chk_val);
           
           /*$teste .= "<pre>";
           $teste .= "\n<b>Dados para pagamento por Multibanco:</b><p>";
		   $teste .= "</p><img src='http://img412.imageshack.us/img412/9672/30239592.jpg' align='left' width='45'";
           $teste .= "\n<b> Entidade:    </b>".$ent_id;
           $teste .= "\n<b> Referncia:  </b>".$subent_id." ".substr($chk_str, 8, 3)." ".substr($chk_str, 11, 1).$chk_digits;
           $teste .= "\n<b> Valor:       </b>".round($order_value,2)." ";
		   $teste .= "\n\n<span style=\"font-size: 9px\">O talo emitido pela caixa automtica faz prova de pagamento. Conserve-o.</span>";
           $teste .= "</pre>";*/
		   //setlocale(LC_MONETARY, 'pt_PT');
		   $teste = '<div align="center"><table cellpadding="3" width="280px" cellspacing="0" style="margin-top: 10px;border: 1px solid #45829F">
    <tr>
        <td style="font-size: x-small; border-bottom: 1px solid #45829F; background-color: #45829F; color: White" colspan="3">Pagamento por Multibanco ou Homebanking</td>
    </tr>
    <tr>
        <td rowspan="3" align="center"><img src="http://img412.imageshack.us/img412/9672/30239592.jpg" alt="left" width="45px" /></td>
        <td style="font-size: x-small; font-weight:bold; text-align:left">Entidade:</td>
        <td style="font-size: x-small; text-align:left">'.$ent_id.'</td>
    </tr>
    <tr>
        <td style="font-size: x-small; font-weight:bold; text-align:left">Referncia:</td>
        <td style="font-size: x-small; text-align:left">'.$subent_id." ".substr($chk_str, 8, 3)." ".substr($chk_str, 11, 1).$chk_digits.'</td>
    </tr>
    <tr>
        <td style="font-size: x-small; font-weight:bold; text-align:left">Valor:</td>
        <td style="font-size: x-small; text-align:left">'.$order_value.' </td>
    </tr>
    <tr>
        <td style="font-size: xx-small;border-top: 1px solid #45829F; background-color: #45829F; color: White" colspan="3">O talo emitido pela caixa automtica faz prova de pagamento. Conserve-o.</td>
    </tr>
</table></div>';

		   
		   
		   
		   
		   return $teste;
    }    
    
	
   function confirmation() { 

   
 
   
    return array('title' => '');
    }
   
   




    function process_button() {
      return false;
    }

    function before_process() {
      return false;
    }

    function after_process() {
	
	 global $db, $order;
   
		  

   $orders_query = "SELECT * FROM " . TABLE_ORDERS . "
                 WHERE customers_id = :customersID
                 ORDER BY date_purchased DESC LIMIT 1";
$orders_query = $db->bindVars($orders_query, ':customersID', $_SESSION['customer_id'], 'integer');
$orders = $db->Execute($orders_query);
$orders_id = $orders->fields['orders_id'];

   
   $n=$orders_id;
   

   $pagamento = $this->GenerateMbRef($n, $order->info['total']);
   $pag=$pagamento;
   
   
	$_SESSION['payment_method_messages']=$pag;
	define('MODULE_PAYMENT_MULTIBANCO_INFO_' . $n,'Aqui vai aparecer os multibancos');
	return false;
    }

    function get_error() {
      return false;
    }

    function check() {
	 global $db;
      if (!isset($this->_check)) {
        $check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_MULTIBANCO_STATUS'");
        $this->_check = $check_query->RecordCount();
      }
      return $this->_check;
    }

    function install() {
	global $db;
	  $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordem de exibio.', 'MODULE_PAYMENT_MULTIBANCO_SORT_ORDER', '0', 'Ordem de exibio', '6', '0', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Pas de Pagamento Permitido', 'MODULE_PAYMENT_MULTIBANCO_ZONE', '0', 'Se um Pas for seleccionado, o pagamento s estar disponvel para esse mesmo Pas.', '6', '2', 'zen_get_zone_class_title', 'zen_cfg_pull_down_zone_classes(', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Activar o mdulo Transferncia', 'MODULE_PAYMENT_MULTIBANCO_STATUS', 'True', '', '6', '1', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Mensagem (Opes de Pagamento)', 'MODULE_PAYMENT_MULTIBANCO_TEXT_SELECTION', 'Dados para pagamento por Multibanco', 'Texto a ser exibido para o cliente nas opes de pagamento:', '6', '2', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Numero da Entidade', 'MODULE_PAYMENT_MULTIBANCO_ENTIDADE', '', 'Numero da Entidade', '6', '3', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Numero da SubEntidade', 'MODULE_PAYMENT_MULTIBANCO_SUB_ENTIDADE', '', 'Numero da SubEntidade', '6', '4', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Texto a Enviar no Email', 'MODULE_PAYMENT_MULTIBANCO_TEXT_CONFIRMATION', 'Seu pedido ser enviado quando confirmado o pagamento. Para agilizar o processo, envie o comprovante por fax: (xx)xxxx-xxxx ou email: a@a.com.', 'Texto a Enviar no Email', '6', '5', now())");



   }


    function remove() {
	  global $db;
      $db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_MULTIBANCO_SORT_ORDER','MODULE_PAYMENT_MULTIBANCO_STATUS', 'MODULE_PAYMENT_MULTIBANCO_TEXT_SELECTION', 'MODULE_PAYMENT_MULTIBANCO_ENTIDADE','MODULE_PAYMENT_MULTIBANCO_SUB_ENTIDADE','MODULE_PAYMENT_MULTIBANCO_TEXT_CONFIRMATION', 'MODULE_PAYMENT_MULTIBANCO_ZONE');

    }
  }
   
?>